<?php echo ($this->ccsettings->item('draft_mode_q') == 1) ? '<div id="draft">' : '<div id="report">'; ?>

<?= date("F j, Y",strtotime($this->ccsettings->item('start_date_time'))); ?> - <?= date("F j, Y",strtotime($this->ccsettings->item('end_date_time'))); ?>
<h2><?=$header?><?php echo ($this->ccsettings->item('draft_mode_q') == 1) ? ' - DRAFT' : ''; ?></h2>

<br />

<div class="buttons">
    <a href="<?=site_url($base_url)?>" class="blue">
    <?= $this->page->icon('arrow_left');?>
    Back
    </a>
</div>

<br />
<br />

<h3>Event Descriptions <small>- Sorted <?=$sort_method?></small></h3>
<p>(NOTE: All events are subject to last minute changes.  Please check back often.)<br /></p>

<?php
	foreach ($events_list->result_array() as $event) {
?>
<br />
<h3><?= $event['name']; ?></h3>
<p>

<?php if ($event['startDateTime'] != '0000-00-00 00:00:00') : ?>
<b>Time:</b> <?= date("l",strtotime($event['startDateTime'])); ?> - <?= date("g:i A",strtotime($event['startDateTime'])); ?> to <?= date("g:i A",strtotime("+".($event['eventLength']*3600).' seconds',strtotime($event['startDateTime']))); ?>
<?php else: ?>
Potential panel/event - Not yet scheduled
<?php endif; ?>

<br />

<?php if ($event['category_name'] != '') : ?>
<b>Category:</b> <?= $event['category_name']; ?>
<br />
<?php endif; ?>

<?php if ($event['track_name'] != '') : ?>
<b>Track:</b> <?= $event['track_name']; ?>
<br />
<?php endif; ?>

<?php if (isset($eventlocations_array[$event['id']])) : ?>
<b>Location:</b> <?=(isset($eventlocations_array[$event['id']])) ? $eventlocations_array[$event['id']] : ''; ?>
<br />
<?php endif; ?>

<?php if (isset($eventparticipants_array[$event['id']])) : ?>
  <?php if ($event['hidePanelistsQ'] == 0) : ?>
<b><?= $event['hostDescription']; ?>:</b> <?=(isset($eventparticipants_array[$event['id']])) ? $eventparticipants_array[$event['id']] : ''; ?>
<br />
  <?php elseif ($mode == 'internal') : ?>
<b><?= $event['hostDescription']; ?>:</b> <?=(isset($eventparticipants_array[$event['id']])) ? $eventparticipants_array[$event['id']] : ''; ?>
<br />
  <?php endif; ?>
<?php elseif ($mode == 'internal') : ?>
<b>No panelists have been assigned yet.</b><br />
<?php endif; ?>

<?php if ($event['description'] != '') : ?>
  <?php if (substr($event['description'], 0, 3) == '<p>') : ?>
    <?php
      // remove leading and trailing paragraph tags
      $event['description'] = substr($event['description'], 3, strlen($event['description']));
      $event['description'] = strrev($event['description']);
      $event['description'] = substr($event['description'], 4, strlen($event['description']));
      $event['description'] = strrev($event['description']);
    ?>
  <?php endif; ?>
<?php endif; ?>


<?php if ($event['description'] != '') : ?>
<b>Description:</b> <?= $event['description']; ?>
<br />
<?php endif; ?>

<?php if ($mode == 'internal') : ?>
<b>Event Length:</b> <?= $event['eventLength']; ?>
<br />
<b>Setup Time:</b> <?= $event['setupTime']; ?>
<br />
<b>Teardown Time:</b> <?= $event['teardownTime']; ?>
<br />
<b>Active?</b> <?= ($event['activeQ']) ? 'Yes' : 'No' ; ?>
<br />
<b>Reimbursible?</b> <?= ($event['reimbursibleQ']) ? 'Yes' : 'No' ; ?>
<br />
<b>Hide?</b> <?= ($event['hideQ']) ? 'Yes' : 'No' ; ?>
<br />
<b>Hide Panelists?</b> <?= ($event['hidePanelistsQ']) ? 'Yes' : 'No' ; ?>
<br />
<b>Location Setup:</b> <?= $event['locationSetup_name']; ?>
<br />
<?php endif; ?>
</p>

<?php }  //end foreach loop ?>

<br />

</div>

<div class="buttons">
    <a href="<?=site_url($base_url)?>" class="blue">
    <?= $this->page->icon('arrow_left');?>
    Back
    </a>
</div>

