<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : locationSetups_model.php
 *
 * DESCRIPTION   : locationSetups model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		locationSetups model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */
class Locationsetups_model extends base_model
{

	function Locationsetups_model()
	{
		parent::Base_model();

		$this->_TABLES = array(
			'locationSetups' => $this->config->item('concentric_table_prefix') . 'locationSetups',
			'colors' => $this->config->item('concentric_table_prefix') . 'colors'
			);

		// Cache to store already fetched items
		$this->_CACHE = array();

	}

	function fetchLocationSetups()
	{
		// Build a query to get the data
		$this->db->select('locationSetup.id, locationSetup.name, locationSetup.description, color.id AS color_id, color.name AS color_name, color.htmlCode AS color_htmlCode');
		$this->db->from($this->_TABLES['locationSetups'] . ' locationSetup');
		$this->db->join($this->_TABLES['colors'] . ' color', 'color.id = locationSetup.colorID', 'left');
		$this->db->order_by('locationSetup.name ASC');
		$query = $this->db->get();
		return $query;
	}

}



/* End of file colors_model.php */
/* Location: ./system/application/models/colors_model.php */
