<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : locations_model.php
 *
 * DESCRIPTION   : locations model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		locations model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */
class Locations_model extends base_model
{

	function Locations_model()
	{
		parent::Base_model();

		$this->_TABLES = array('locations' => $this->config->item('concentric_table_prefix') . 'locations',
								'colors' => $this->config->item('concentric_table_prefix') . 'colors');

		// Cache to store already fetched items
		$this->_CACHE = array();

	}

	function fetchLocations()
	{
		// Build a query to get the data
		$this->db->select('location.id, location.name, location.alternateName, location.capacity, location.sortOrder, location.publicQ, color.id AS color_id, color.name AS color_name, color.htmlCode AS color_htmlCode');
		$this->db->from($this->_TABLES['locations'] . ' location');
		$this->db->join($this->_TABLES['colors'] . ' color', 'color.id = location.colorID', 'left');
		$this->db->order_by('location.sortOrder ASC');
		$query = $this->db->get();
		return $query;
	}

	function fetchLocationColor($locationID = '')
	{
		if ($locationID == '')
			return FALSE;
		
		$data = '';
		$this->db->select('color.htmlCode');
		$this->db->from($this->_TABLES['locations'] . ' location');
		$this->db->where('location.id = ' . $locationID);
		$this->db->join($this->_TABLES['colors'] . ' color', 'color.id = location.colorID', 'left');
		$query = $this->db->get();
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			$data = $row['name'];
		}

		return $data;
	}

	function fetchLocationName($locationID = '')
	{
		if ($locationID == '')
			return FALSE;
		
		$data = '';
		$this->db->select('name');
		$this->db->from($this->_TABLES['locations'] . ' location');
		$this->db->where('location.id = ' . $locationID);
		$query = $this->db->get();
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			$data = $row['name'];
		}
		//else
		//{
		//	flashMsg('info','What?');
		//}

		return $data;
	}

}



/* End of file locations_model.php */
/* Location: ./system/application/models/locations_model.php */
