<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : events_model.php
 *
 * DESCRIPTION   : Events model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		Events model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Events_model extends base_model
{

	// -------------------------------------------------------------------------
	function Events_model()
	{
		parent::Base_model();

		// Include all tables that are linked to from events
		$this->_TABLES = array(
				'events' => $this->config->item('concentric_table_prefix') . 'events',
				'categories' => $this->config->item('concentric_table_prefix') . 'categories',
				'tracks' => $this->config->item('concentric_table_prefix') . 'tracks',
				'locationSetups' => $this->config->item('concentric_table_prefix') . 'locationSetups'
				);

		// Cache to store already fetched items
		$this->_CACHE = array();
	}

	// -------------------------------------------------------------------------
	function fetchEvents($where = '', $orderby = 'event.name ASC')
	{
		// Build a query to get the data
		$this->db->select('event.id, event.name, event.startDateTime, event.description, event.eventLength, event.setupTime, event.teardownTime, event.reimbursibleQ, event.activeQ, event.hideQ, event.hostDescription, event.hidePanelistsQ, locationSetup.id AS locationSetup_id, locationSetup.name AS locationSetup_name, category.id AS category_id, category.name AS category_name, track.id AS track_id, track.name AS track_name, track.publicQ AS track_publicQ');
		$this->db->from($this->_TABLES['events'] . ' event');
		$this->db->join($this->_TABLES['categories'] . ' category', 'category.id = event.categoryID', 'left');
		$this->db->join($this->_TABLES['locationSetups'] . ' locationSetup', 'locationSetup.id = event.locationSetupID', 'left');
		$this->db->join($this->_TABLES['tracks'] . ' track', 'track.id = event.trackID', 'left');
		$this->db->order_by($orderby);
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/**
	 * Get the next record using name
	 *
	 * @access public
	 * @params string oldNm old name
	 */
	function getNextByName($oldNm = '')
	{
		$this->db->select('id, name');
		$this->db->from($this->_TABLES['events']);
		$this->db->where('name > "' . $oldNm . '"');
		$this->db->order_by('name','ASC');
		$this->db->limit(1);
		$query = $this->db->get();

		$nextId = 0;
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			$nextId = $row['id'];
		}

		return $nextId;
	}


	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------
	/**
	 * Build a grid of scheduled events and the locations they are in
	 *
	 * @access    private
	 */
	function build_location_grid($locations, $mode = 'internal', $grid_interval = '')
	{
		$this->CI = & get_instance();

		if ($grid_interval == '')
			$grid_interval = $this->ccsettings->item('interval_length');

		// Build an empty location grid
		$locationGrid = build_empty_grid($this->ccsettings->item('start_date_time'),
										$this->ccsettings->item('end_date_time'),
										$grid_interval,
										$locations);

		// load eventlocations model
		$this->CI->load->model('eventlocations_model');

		if ($mode == 'public')
		{
			// Select all public events with a startdatetime and a location assignment
			$query = $this->CI->eventlocations_model->fetchPublicScheduledEvents();
		}
		else
		{
			// Select all events with a startdatetime and a location assignment
			$query = $this->CI->eventlocations_model->fetchScheduledEvents();
		}

		//loop thru events and add to grid
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //event id
			$locationsort = array($row['sortOrder'] => $row['locationID']);  //location sortOrder
			$locationcnt = $this->CI->eventlocations_model->count_condition('eventLocations','eventID = '.$id);
			$sdttm = strtotime($row['startDateTime']);
			$edttm = strtotime("+".($row['eventLength']*3600).' seconds', $sdttm);
			$setup = strtotime("-".($row['setupTime']*3600).' seconds', $sdttm);
			$teardown = strtotime("+".($row['teardownTime']*3600).' seconds', $edttm);
			$eventInfo = array('id' => $id,
							'locationcnt' => $locationcnt,
							'sdttm' => date('Y-m-d H:i:s',$sdttm),
							'edttm' => date('Y-m-d H:i:s',$edttm),
							'setupdttm' => date('Y-m-d H:i:s',$setup),
							'teardowndttm' => date('Y-m-d H:i:s',$teardown),
							'setup' => $row['setupTime'],
							'teardown' => $row['teardownTime'],
							'eventlength' => $row['eventLength']
							);
			
			//if ($id == 143)
			//	print_r($eventInfo);
			$locationGrid = assign_event_to_locationgrid($locationGrid, $locationsort, $eventInfo, $grid_interval);
		}
		//print_r($locationGrid);
		return $locationGrid;
	}

	// -------------------------------------------------------------------------
	/**
	 * Build a grid of scheduled events and the participants on them
	 *
	 * @access    private
	 */
	function build_part_grid($participants)
	{
		$this->CI = & get_instance();

		// Build an empty participant grid
		$partGrid = build_empty_grid($this->ccsettings->item('start_date_time'),
										$this->ccsettings->item('end_date_time'),
										$this->ccsettings->item('interval_length'),
										$participants);

		// Select all events with a startdatetime and a participant
		$this->CI->load->model('eventparticipants_model');
		$query = $this->CI->eventparticipants_model->fetchScheduledEvents();

		//loop thru events and add to grid
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //event id
			$partsort = array($row['sortedName'] => 1);
			$sdttm = strtotime($row['startDateTime']);
			$edttm = strtotime("+".($row['eventLength']*3600).' seconds', $sdttm);
			$setup = strtotime("-".($row['setupTime']*3600).' seconds', $sdttm);
			$teardown = strtotime("+".($row['teardownTime']*3600).' seconds', $edttm);
			$eventInfo = array('id' => $id,
							'sdttm' => date('Y-m-d H:i:s',$sdttm),
							'edttm' => date('Y-m-d H:i:s',$edttm),
							'setupdttm' => date('Y-m-d H:i:s',$setup),
							'teardowndttm' => date('Y-m-d H:i:s',$teardown),
							'setup' => $row['setupTime'],
							'teardown' => $row['teardownTime'],
							'eventlength' => $row['eventLength']
							);
			
			$partGrid = assign_event_to_partgrid($partGrid, $partsort, $eventInfo, $this->ccsettings->item('interval_length'));
		}
		//print_r($this->partGrid);
		return $partGrid;
	}


	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------
	/**
	 * Build a grid of scheduled events and the locations they are in
	 *
	 * @access    private
	 */
	function build_event_grid($locations, $mode = 'publication', $sort = 'category')
	{
		if ($mode != 'publication')
			return FALSE;


		$this->CI = & get_instance();

		// load eventlocations model
		$this->CI->load->model('eventlocations_model');
		// load eventparticipants model
		$this->CI->load->model('eventparticipants_model');
		// load categories model
		$this->CI->load->model('categories_model');
		// load departments model
		$this->CI->load->model('departments_model');
		// load departmenthours model
		$this->CI->load->model('departmenthours_model');
		// load grid helper
		$this->CI->load->helper('grid_helper');


		// Select all events for publication with a startdatetime and a location assignment
		$query = $this->CI->eventlocations_model->fetchPublicationScheduledEvents('', $sort);
		//$grid = $query->result_array();
		//return '<pre>' . print_r($grid,TRUE) . '</pre>';

		//loop thru events and add to grid array
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //event id
			$catID = $row['categoryID'];  //category id
			$sdttm = $row['startDateTime'];  //start datetime
			list($sdt, $stm) = explode(' ', $sdttm);  //separate into parts
			$stm1 = explode(':', $stm);  //separate time parts
			$stm = $stm1[0] . ':' . $stm1[1];  //remove seconds from time

			// if sort is all, list all events together instead of sorted by category
			if ($sort == 'all')
				$catID = 1;

			// count events per cat/dt/tm
			$grid[$catID][$sdt][$stm]['cnt'] = isset($grid[$catID][$sdt][$stm]['cnt']) ? $grid[$catID][$sdt][$stm]['cnt'] + 1 : 1;
			$grid[$catID][$sdt][$stm]['events'][] = $id;
		}
		$query->free_result();


		// Select all departmenthours for publication
		$query = $this->CI->departmenthours_model->fetchDepartmentHours();
		//$grid = $query->result_array();
		//return '<pre>' . print_r($grid,TRUE) . '</pre>';

		//loop thru departmenthours and add to grid array
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //departmenthour id
			$dttm = $row['datetime'];  //datetime
			list($dt, $tm) = explode(' ', $dttm);  //separate into parts
			$tm1 = explode(':', $tm);  //separate time parts
			$tm = $tm1[0] . ':' . $tm1[1];  //remove seconds from time

			$catID = 1;

			// count departmenthours per cat/dt/tm
			$grid[$catID][$dt][$tm]['cnt'] = isset($grid[$catID][$dt][$tm]['cnt']) ? $grid[$catID][$dt][$tm]['cnt'] + 1 : 1;
			$grid[$catID][$dt][$tm]['departmenthours'][] = $id;
		}
		$query->free_result();


		//return '<pre>' . print_r($grid,TRUE) . '</pre>';


		//loop thru grid array by category and create html output for display
		$output = '';
		foreach ($grid as $catID=>$catarr)
		{
			if ($sort == 'category')
			{
			// get category name
				$query = $this->CI->categories_model->fetch('categories','name','','id = '.$catID);
				$row = $query->row_array();
				$query->free_result();
			} else
			{
				$row['name'] = 'All Events';
			}
			$output .= '<h3>' . $row['name'] . '</h3>' . "\n";

			$output .= '<table class=grid border=1>' . "\n";

			foreach ($catarr as $dt=>$dtarr)
			{
				foreach ($dtarr as $tm=>$tmarr)
				{
					$cnt = $tmarr['cnt'];
					$flag = 0;
					$events = array();
					$departmenthours = array();

					if (array_key_exists('events', $tmarr)) {
						$events = $tmarr['events'];
					}
					foreach ($events as $eventID)
					{
						// get event data
						$query = $this->CI->events_model->fetchEvents('event.id = '.$eventID);
						$row = $query->row_array();
						$query->free_result();

						$output .= '<tr>' . "\n";
						// if first time thru loop, display day and time in first column
						if ($flag == 0)
						{
							$flag = 1;  // change flag to indicate already done
							$output .= '<td rowspan='.$cnt.'>';
							$output .= date('l', strtotime($dt));  //name of day
							$output .= '<br>';
							$output .= cnv_tm_from_military($tm);  //time of day
							$output .= '</td>' . "\n";
						}

						// get locations for second column
						$locations = $this->CI->eventlocations_model->convertLocationsToStrAlternate('event.id = '.$eventID);
						$output .= '<td>';
						$output .= $locations[$eventID];
						$output .= '</td>' . "\n";

						$sdttm = strtotime($row['startDateTime']);  //start dttm
						$edttm = strtotime("+".($row['eventLength']*3600).' seconds', $sdttm);  //end dttm
						$edttm = date('Y-m-d H:i:s',$edttm);  //change back to sql
						list($edt, $etm) = explode(' ', $edttm);  //separate into parts
						$etm1 = explode(':', $etm);  //separate time parts
						$etm = $etm1[0] . ':' . $etm1[1];  //remove seconds from time
						$etm = cnv_tm_from_military($etm);  //convert
						// get participants for third column
						$participants = $this->CI->eventparticipants_model->convertParticipantsToStr('event.id = '.$eventID.' and participant.equipmentQ = 0', 'participant.sortedName ASC', 'public');

						// get event details for third column
						$output .= '<td>';
						$output .= '<b><u>'.$row['name'].'</u></b>';
						$output .= ' (Ends at: ' . $etm . ')<br />' . "\n";
						//check if participants should be hidden
						if ($row['hidePanelistsQ'] == 0 && $participants != '')
						{
							$output .= '<b>' . $row['hostDescription'] . ': </b>';
							$output .= $participants[$eventID] . '<br />' . "\n";
						}
						$output .= $row['description'];
						$output .= '</td>' . "\n";

						$output .= '</tr>' . "\n";
					}

					if (array_key_exists('departmenthours', $tmarr)) {
						$departmenthours = $tmarr['departmenthours'];
					}
					foreach ($departmenthours as $departmenthourID)
					{
						// get departmenthours data
						$query = $this->CI->departmenthours_model->fetchDepartmentHours('departmenthour.id = '.$departmenthourID);
						$row = $query->row_array();
						$query->free_result();

						$output .= '<tr>' . "\n";
						// if first time thru loop, display day and time in first column
						if ($flag == 0)
						{
							$flag = 1;  // change flag to indicate already done
							$output .= '<td rowspan='.$cnt.'>';
							$output .= date('l', strtotime($dt));  //name of day
							$output .= '<br>';
							$output .= cnv_tm_from_military($tm);  //time of day
							$output .= '</td>' . "\n";
						}

						// get locations for second column
						$location = $row['location_name'];
						$department = $row['department_name'];
						$output .= '<td>';
						$output .= $location . ' (' . $department . ')';
						$output .= '</td>' . "\n";

						// get event details for third column
						$output .= '<td>';
						$output .= '<b><u>'.$department.' '.$row['type'].'</u></b>';
						$output .= '</td>' . "\n";

						$output .= '</tr>' . "\n";
					}


				}
			}
			$output .= '</table>' . "\n";
		}

		//return '<pre>' . print_r($grid,TRUE) . '</pre>';
		return $output;
	}


}



/* End of file events_model.php */
/* Location: ./system/application/models/events_model.php */
