<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : eventlocations_model.php
 *
 * DESCRIPTION   : eventlocations model
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-13 2:00 AM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		eventlocations model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Eventlocations_model extends base_model
{

	// -------------------------------------------------------------------------
	function Eventlocations_model()
	{
		parent::Base_model();

		// Include all tables that are linked to from events
		$this->_TABLES = array(
				'eventLocations' => $this->config->item('concentric_table_prefix') . 'eventLocations',
				'events' => $this->config->item('concentric_table_prefix') . 'events',
				'locations' => $this->config->item('concentric_table_prefix') . 'locations',
				'tracks' => $this->config->item('concentric_table_prefix') . 'tracks'
				);

		// Cache to store already fetched items
		$this->_CACHE = array();
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch events that are assigned to a location.
	 */
	function fetchEventLocations($where = '', $orderby = 'event.name ASC, location.sortOrder ASC')
	{
		// Build a query to get the data
		$this->db->select('eventlocation.id, event.id AS event_id, event.name AS event_name, location.id AS location_id, location.name AS location_name, location.sortOrder AS location_sortorder, location.alternateName');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->order_by($orderby);
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch active event(s) with a startDateTime and which is assigned to a location
	 */
	function fetchScheduledEvents($where = '')
	{
		$this->db->select('event.id, location.sortOrder, event.startDateTime, event.eventLength, event.setupTime, event.teardownTime, location.id as locationID');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch active event(s) that are public with a startDateTime and which is assigned to a location
	 */
	function fetchPublicScheduledEvents($where = '')
	{
		$this->db->select('event.id, location.sortOrder, event.startDateTime, event.eventLength, event.setupTime, event.teardownTime, location.id as locationID');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->join($this->_TABLES['tracks'] . ' track', 'event.trackID = track.id', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('track.publicQ = 1');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}


	// -------------------------------------------------------------------------
	/*
	 * Fetch active locations with active, scheduled events
	 * Report used by Location controller
	 */
	function fetchScheduledLocations($where = '', $orderby = 'eventdate ASC, location.sortOrder ASC')
	{
		$this->db->distinct();
		$this->db->select('DATE(event.startDateTime) as eventdate, DAYNAME(event.startDateTime) as eventday, location.sortOrder, location.id, location.name, location.alternateName');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->join($this->_TABLES['tracks'] . ' track', 'event.trackID = track.id', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('event.hideQ = 0');
		$this->db->where('track.publicQ = 1');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->order_by($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}


	// -------------------------------------------------------------------------
	/*
	 * Fetch active, scheduled events by location
	 * Report used by Location controller
	 */
	function fetchScheduledLocations2($where = '', $orderby = 'startDateTime ASC, name ASC')
	{
		$this->db->select('event.id, event.name, event.startDateTime, event.eventLength');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->join($this->_TABLES['tracks'] . ' track', 'event.trackID = track.id', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('track.publicQ = 1');
		$this->db->where('event.hideQ = 0');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->order_by($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}


	// -------------------------------------------------------------------------
	/*
	 * Fetch active event(s) that are for publication with a startDateTime and 
	 *   which is assigned to a location
	 */
	function fetchPublicationScheduledEvents($where = '', $sort = 'category')
	{
		if ($sort == 'all')
		{
			$orderby = 'event.startDateTime ASC, location.sortOrder ASC, event.name ASC';
		}
		else
		{
			$orderby = 'event.categoryID ASC, event.startDateTime ASC, location.sortOrder ASC, event.name ASC';
		}

		$this->db->distinct();
		$this->db->select('event.id, event.startDateTime, event.eventLength, event.categoryID');
		$this->db->from($this->_TABLES['eventLocations'] . ' eventlocation');
		$this->db->join($this->_TABLES['events'] . ' event', 'event.id = eventlocation.eventID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = eventlocation.locationID', 'left');
		$this->db->join($this->_TABLES['tracks'] . ' track', 'event.trackID = track.id', 'left');
		$this->db->where('event.startDateTime != "0000-00-00 00:00:00"');
		$this->db->where('event.activeQ = 1');
		$this->db->where('event.hideQ = 0');
		if ($where)
			$this->db->where($where, NULL, FALSE);
		if ($orderby)
			$this->db->orderby($orderby);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}


	// -------------------------------------------------------------------------
	/**
	* Convert the query object to a array of location strings using event id as key
	*/
	function convertLocationsToStr($where = '', $orderby = 'event.name ASC, location.sortOrder ASC')
	{
		$rows = $this->fetchEventLocations($where, $orderby);

		$data = array();
		$returndata = array();   //5-19-2009
		//loop thru query results and build array
		foreach ($rows->result_array() as $row)
		{
			$data[$row['event_id']][] = $row['location_name'];
		}
		//loop thru array and change values to strings
		foreach ($data as $key => $value)
		{
			$returndata[$key] = implode(', ', $value);
		}
		//flashMsg('info','<pre>'.print_r($returndata, TRUE).'</pre>');
		return $returndata;
	}

	// -------------------------------------------------------------------------
	/**
	* Convert the query object to a array of location strings with alternate name using event id as key
	*/
	function convertLocationsToStrAlternate($where = '', $orderby = 'event.name ASC, location.sortOrder ASC')
	{
		$rows = $this->fetchEventLocations($where, $orderby);
		//flashMsg('info','<pre>'.print_r($rows->num_rows(), TRUE).'</pre>');

		$returndata = array();
		$data = array();
		//loop thru query results and build array
		foreach ($rows->result_array() as $row)
		{
			$str = (isset($row['alternateName']) && $row['alternateName'] != '' ? ' (' . $row['alternateName'] . ')' : '');
			$data[$row['event_id']][] = $row['location_name'] . $str;
		}
		//loop thru array and change values to strings
		foreach ($data as $key => $value)
		{
			$returndata[$key] = implode(', ', $value);
		}
		//flashMsg('info','<pre>'.print_r($returndata, TRUE).'</pre>');
		return $returndata;
	}

}



/* End of file eventlocations_model.php */
/* Location: ./system/application/models/eventlocations_model.php */
