<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : departmenthours_model.php
 *
 * DESCRIPTION   : departmenthours model
 *
 * MODIFICATION HISTORY
 *   V1.0   2010-01-12 12:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		departmenthours model component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2010
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Departmenthours_model extends base_model
{

	// -------------------------------------------------------------------------
	function Departmenthours_model()
	{
		parent::Base_model();

		// Include all tables that are linked to from departments
		$this->_TABLES = array(
				'departments' => $this->config->item('concentric_table_prefix') . 'departments',
				'locations' => $this->config->item('concentric_table_prefix') . 'locations',
				'departmenthours' => $this->config->item('concentric_table_prefix') . 'departmentHours'
				);

		// Cache to store already fetched items
		$this->_CACHE = array();
	}

	// -------------------------------------------------------------------------
	/*
	 * Fetch departments that have hours assigned.
	 */
	function fetchDepartmentHours($where = '', $orderby = 'department.name ASC, departmenthour.datetime ASC')
	{
		// Build a query to get the data
		$this->db->select('departmenthour.id, departmenthour.datetime, departmenthour.type, department.id AS department_id, department.name AS department_name, location.id AS location_id, location.name AS location_name');
		$this->db->from($this->_TABLES['departmenthours'] . ' departmenthour');
		$this->db->join($this->_TABLES['departments'] . ' department', 'department.id = departmenthour.departmentID', 'left');
		$this->db->join($this->_TABLES['locations'] . ' location', 'location.id = department.locationID', 'left');
		if ($orderby)
			$this->db->order_by($orderby);
		if ($where)
			$this->db->where($where, NULL, FALSE);
		$query = $this->db->get();
		//flashMsg('info',$this->db->last_query());
		return $query;
	}



}



/* End of file departmenthours_model.php */
/* Location: ./system/application/models/departmenthours_model.php */
