<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : tools.php
 *
 * DESCRIPTION   : tools module controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-29 7:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		tools component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Tools extends Concentric_Controller
{
	/**
	* Contructor function
	*
	* Load the instance of CI by invoking the parent constructor
	*
	* @access      public
	* @return      none
	*/
	function Tools()
	{
		// Call parent constructor
		parent::Concentric_Controller();

		$this->form_name = "Tools";
	}

	// -------------------------------------------------------------------------
	/**
	* "Index" Page
	*
	* Default class action
	*
	* @access      public
	* @return      none
	*/
	function index()
	{
		// The default action is the menu action
		$this->menu();
	}


	// --------------------------------------------------------------------------------------------
	// Menu
	// --------------------------------------------------------------------------------------------

	// -------------------------------------------------------------------------
	/**
	* Menu Page
	*
	* @access      public
	* @return      none
	*/
	function menu()
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/tools/menu/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumb
		$this->page->set_crumb('Tools','concentric/tools/menu/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html
		$data['content'] = $this->load->view('/concentric/tools/tools_menu', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Check for conflicts
	*
	* @access      public
	* @return      none
	*/
	function conflicts()
	{
		// load grid helper
		$this->load->helper('grid');
		// load helper library
		$this->load->helper('concentric');
		// load models
		$this->load->model('participants_model');
		$this->load->model('locations_model');
		$this->load->model('events_model');

		// create urls for use in content view
		$template['base_url']   = 'concentric/tools/conflicts/';
		$template['cancel_url'] = 'concentric/tools';

		// Set breadcrumb
		$this->page->set_crumb('Tools','concentric/tools/menu/');
		$this->page->set_crumb('Check for Conflicts','concentric/tools/conflicts/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// initialize content arrays
		$template['content'] = '';
		$template['conflict_content'] = '';

		// count locations for grid
		$query = $this->locations_model->fetch('locations', 'id, sortOrder', '', '', 'sortOrder ASC');  //get data
		$locationcnt = $query->num_rows();
		$query->free_result();
		$template['content'] .= 'Number of locations checked: ' . $locationcnt . '<br />' . "\n";

		// count active participants for grid
		$query = $this->participants_model->fetch('participants', 'id, sortedName', '', 'activeQ = 1', 'sortedName ASC');  //get data
		$partcnt = $query->num_rows();
		$query->free_result();
		$template['content'] .= 'Number of participants checked: ' . $partcnt . '<br />' . "\n";


		// build conflict content html
		// check for location conflicts
		$template['conflict_content'] .= $this->_check_location_conflicts();  //check for locations conflicts

		// loop and check for participant conflicts
		$rows = 50;  // only do 50 participants at a time
		$offset = 0;
		do {
			$template['conflict_content'] .= $this->_check_part_conflicts($rows,$offset);  //check for part conflicts
			$offset = $offset+$rows;
		} while ($offset < $partcnt);

		$data['content'] = $this->load->view('/concentric/tools/tools_conflicts', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	 * Build a grid of scheduled events and the locations they are in and check for
	 * conflicts.
	 *
	 * @access    private
	 */
	function _check_location_conflicts()
	{
		// Need to create a list of locations for grid
		$query = $this->locations_model->fetch('locations', 'id, sortOrder', '', '', 'sortOrder ASC');  //get data
		foreach ($query->result_array() as $row)
		{
			$locations[$row['sortOrder']] = $row['id'];
		}
		$query->free_result();

		// Build an empty location grid
		$locationGrid = build_empty_grid($this->ccsettings->item('start_date_time'),
										$this->ccsettings->item('end_date_time'),
										$this->ccsettings->item('interval_length'),
										$locations);

		// Select all events with a startdatetime and a location assignment
		$this->load->model('eventlocations_model');
		$query = $this->eventlocations_model->fetchScheduledEvents();

		// status of checks
		$status = '';

		//loop thru events and add to grid
		foreach ($query->result_array() as $row)
		{
			$id = $row['id'];  //event id
			$locationsort = array($row['sortOrder'] => 1);  //location sortOrder
			$locationcnt = $this->eventlocations_model->count_condition('eventLocations','eventID = '.$id);
			$sdttm = strtotime($row['startDateTime']);
			$edttm = strtotime("+".($row['eventLength']*3600).' seconds', $sdttm);
			$setup = strtotime("-".($row['setupTime']*3600).' seconds', $sdttm);
			$teardown = strtotime("+".($row['teardownTime']*3600).' seconds', $edttm);
			$eventInfo = array('id' => $id,
							'locationcnt' => $locationcnt,
							'sdttm' => date('Y-m-d H:i:s',$sdttm),
							'edttm' => date('Y-m-d H:i:s',$edttm),
							'setupdttm' => date('Y-m-d H:i:s',$setup),
							'teardowndttm' => date('Y-m-d H:i:s',$teardown),
							'setup' => $row['setupTime'],
							'teardown' => $row['teardownTime'],
							'eventlength' => $row['eventLength']
							);

			$event_status = '';
			$event_status = check_event_on_locationgrid($locationGrid, $locationsort, $eventInfo, $this->ccsettings->item('interval_length'));

			if ($event_status == '')
			{
				// if no conflict, add event to grid
				$locationGrid = assign_event_to_locationgrid($locationGrid, $locationsort, $eventInfo, $this->ccsettings->item('interval_length'));
			} else {
				// otherwise, report status
				$eventquery = $this->events_model->fetch('events','name','',array('id'=>$id));
				$row = $eventquery->row_array();
				$status .= '<u><b>Event id ' . $id . ' (' . $row['name'] . ')</b></u><br />';
				$status .= $event_status;
			}
		}
		$query->free_result();

		return $status;
	}

	// -------------------------------------------------------------------------
	/**
	 * Build a grid of scheduled events and the participants assigned and check for
	 * conflicts.
	 *
	 * @access    private
	 */
	function _check_part_conflicts($rows = '', $offset = 0)
	{
		if ($rows != '')
			$limit = array('rows'=>$rows,'offset'=>$offset);

		// Need to create a list of active participants for grid
		$query = $this->participants_model->fetch('participants', 'id, sortedName', $limit, 'activeQ = 1', 'sortedName ASC');  //get data
		foreach ($query->result_array() as $row)
		{
			$participants[$row['sortedName']] = $row['id'];
		}
		$query->free_result();

		// Build an empty participant grid
		$partGrid = build_empty_grid($this->ccsettings->item('start_date_time'),
										$this->ccsettings->item('end_date_time'),
										$this->ccsettings->item('interval_length'),
										$participants);

		// Select all events with a startdatetime and a participant assignment
		$this->load->model('eventparticipants_model');
		$query = $this->eventparticipants_model->fetchScheduledEvents();

		// status of checks
		$status = '';

		//loop thru events and add to grid
		foreach ($query->result_array() as $row)
		{
			if (!isset($participants[$row['sortedName']]))
				continue;
			$id = $row['id'];  //event id
			$partsort = array($row['sortedName'] => 1);  //participant sortedName
			$sdttm = strtotime($row['startDateTime']);
			$edttm = strtotime("+".($row['eventLength']*3600).' seconds', $sdttm);
			$setup = strtotime("-".($row['setupTime']*3600).' seconds', $sdttm);
			$teardown = strtotime("+".($row['teardownTime']*3600).' seconds', $edttm);
			$eventInfo = array('id' => $id,
							'sdttm' => date('Y-m-d H:i:s',$sdttm),
							'edttm' => date('Y-m-d H:i:s',$edttm),
							'setupdttm' => date('Y-m-d H:i:s',$setup),
							'teardowndttm' => date('Y-m-d H:i:s',$teardown),
							'setup' => $row['setupTime'],
							'teardown' => $row['teardownTime'],
							'eventlength' => $row['eventLength']
							);

			$event_status = '';
			$event_status = check_event_on_partgrid($partGrid, $partsort, $eventInfo, $this->ccsettings->item('interval_length'));

			if ($event_status == '')
			{
				// if no conflict, add event to grid
				$partGrid = assign_event_to_partgrid($partGrid, $partsort, $eventInfo, $this->ccsettings->item('interval_length'));
			} else {
				// otherwise, report status
				$eventquery = $this->events_model->fetch('events','name','',array('id'=>$id));
				$row = $eventquery->row_array();
				$status .= '<u><b>Event id ' . $id . ' (' . $row['name'] . ')</b></u><br />';
				$status .= $event_status;
			}
		}
		$query->free_result();

		return $status;
	}

	// -------------------------------------------------------------------------
	/**
	* Create a css file to use on grid
	*
	* @access      public
	* @return      none
	*/
	function create_grid_css()
	{
		$this->load->helper('grid');		// load grid helper
		$this->load->helper('concentric');	// load concentric helper
		$this->load->helper('file');		// load file helper

		// create urls for use in content view
		$template['base_url']   = 'concentric/tools/create_grid_css/';
		$template['cancel_url'] = 'concentric/tools';

		// Set breadcrumb
		$this->page->set_crumb('Tools','concentric/tools/menu/');
		$this->page->set_crumb('Create Grid Style Sheet','concentric/tools/create_grid_css/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;


		// Need to create a list of locations for grid
		$this->load->model('locations_model');    // Instantiate the model
		$query = $this->locations_model->fetchLocations();  //get data
		$this->locationarray = $query->result_array();

		$filedata = $this->_output_grid_css();

		$template['content'] = '';
		if ( ! write_file('./assets/shared/css/grid.css', $filedata))
		{
			$template['content'] = 'Unable to create the file for the grid style sheet.';
		}
		else
		{
			$template['content'] = 'The grid style sheet was created.';
		}

		$data['content'] = $this->load->view('/concentric/tools/tools_create_grid_css', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}


	// -------------------------------------------------------------------------
	/**
	 * Output the grid css
	 *
	 * @access    private
	 */
	function _output_grid_css()
	{
		$output = '';
		$output .= '.grid{' . "\n";
		$output .= '	font-family:arial;' . "\n";
		$output .= '	font-size:12px;' . "\n";
		$output .= '	/* width:400px; */' . "\n";
		$output .= '	empty-cells: show;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= '.grid th{' . "\n";
		$output .= '	margin:0px;' . "\n";
		$output .= '	padding:2px;' . "\n";
		$output .= '	empty-cells: show;' . "\n";
		$output .= '	border-bottom:1px solid black; /* Border bottom of table data cells */' . "\n";
		$output .= '	border-right:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	border-left:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	border-top:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	max-height:10px;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= '.grid td{' . "\n";
		$output .= '	margin:0px;' . "\n";
		$output .= '	padding:2px;' . "\n";
		$output .= '	empty-cells: show;' . "\n";
		$output .= '	border-bottom:1px solid black; /* Border bottom of table data cells */' . "\n";
		$output .= '	border-right:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	border-left:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	border-top:1px solid black;  /* Border bottom of table data cells */' . "\n";
		$output .= '	max-height:10px;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= '.grid tbody{' . "\n";
		$output .= '	background-color:#FFF;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= '.grid thead{' . "\n";
		$output .= '	/*position:relative; */ ;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= '.grid thead tr{' . "\n";
		$output .= '	/*position:relative; */' . "\n";
		$output .= '	top:0px;' . "\n";
		$output .= '	bottom:0px;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= 'TH.setup, TD.setup{' . "\n";
		$output .= '	border-style: solid;' . "\n";
		$output .= '	border-width: 1px;' . "\n";
		$output .= '	border-color: black;' . "\n";
		$output .= '	padding: 2px;' . "\n";
		$output .= '	background: red;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= 'TH.teardown, TD.teardown{' . "\n";
		$output .= '	border-style: solid;' . "\n";
		$output .= '	border-width: 1px;' . "\n";
		$output .= '	border-color: black;' . "\n";
		$output .= '	padding: 2px;' . "\n";
		$output .= '	background: red;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		$output .= 'TH.white, TD.white{' . "\n";
		$output .= '	border-style: solid;' . "\n";
		$output .= '	border-width: 1px;' . "\n";
		$output .= '	border-color: black;' . "\n";
		$output .= '	padding: 2px;' . "\n";
		$output .= '	background: white;' . "\n";
		$output .= '}' . "\n";
		$output .= "\n";

		foreach ($this->locationarray as $row)
		{
			$classname = classname($row['name']);
			$output .= 'th.' . $classname . ', td.' . $classname . '{' . "\n";
			$output .= '	border-style: solid;' . "\n";
			$output .= '	border-width: 1px;' . "\n";
			$output .= '	border-color: black;' . "\n";
			$output .= '	padding: 2px;' . "\n";
			$output .= '	background: #' . $row['color_htmlCode'] . ';' . "\n";
			$output .= '}' . "\n";
			$output .= "\n";
		}

		return $output;
	}


}


/* End of file tools.php */
/* Location: ./system/application/controllers/concentric/tools.php */