<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : Home.php
 *
 * DESCRIPTION   : home controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		home Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

// ---------------------------------------------------------------------------

/**
* Home
*
* @package			ConCentric
* @subpackage		Controllers
*/     
class Home extends Concentric_Controller
{
	function Home()
	{
		parent::Concentric_Controller();

		// Load dashboard language file
		$this->lang->load('dashboard');

		log_message('debug','ConCentric Home Class Initialized'); 
	}

	function index()
	{
		// Include dashboard Javascript code
		$this->page->set_asset('admin','js','dashboard.js');

		// Load the dashboard library
		$this->load->library('dashboard');

		// Assign widgets to dashboard
		$this->dashboard->assign_widget(new widget($this->lang->line('dashboard_help'),$this->_widget_help()),'right');
		
		// Check if the user has access to the programming menu
		if ( check('Programming Menu',NULL,FALSE) == TRUE )
		{
			// Create programming statistics widget
			$this->dashboard->assign_widget(new widget($this->lang->line('dashboard_programming'),$this->_widget_programming_statistics()),'left');
			// Create programming help widget
			$this->dashboard->assign_widget(new widget($this->lang->line('dashboard_proghelp'),$this->lang->line('dashboard_proghelp_body'),'right'));
		}

		// Load dashboard onto page
		$data['dashboard'] = $this->dashboard->output();

		// Display Page
		$data['header'] = $this->lang->line('backendpro_dashboard');
		$data['page'] = $this->config->item('concentric_template_admin') . "home";
		$this->load->view($this->_container,$data);
	}

	/**
	* Generate the contents of the programming statistics widget and return it as html.
	*
	* @access private
	* @return string
	*/
	function _widget_programming_statistics()
	{
		$this->load->model('events_model');
		$this->load->model('participants_model');

		// Get statistics for events
		$query = $this->events_model->fetch('events','id');
		$data['total_events'] = $query->num_rows();

		$array = array('startDateTime' => '0000-00-00 00:00:00');
		$query = $this->events_model->fetch('events','id','',$array);
		$data['total_unscheduled_events'] = $query->num_rows();

		// Get statistics for participants
		$query = $this->participants_model->fetch('participants','id');
		$data['total_participants'] = $query->num_rows();
		
		$array = array('activeQ' => 1, 'equipmentQ' => 0, 'hideQ' => 0);
		$query = $this->participants_model->fetch('participants','id','',$array);
		$data['total_active_participants'] = $query->num_rows();
		
		$array = array('activeQ' => 0, 'equipmentQ' => 0, 'hideQ' => 0);
		$query = $this->participants_model->fetch('participants','id','',$array);
		$data['total_inactive_participants'] = $query->num_rows();
		
		$array = array('equipmentQ' => 1);
		$query = $this->participants_model->fetch('participants','id','',$array);
		$data['total_equipment'] = $query->num_rows();

		$array = array('hideQ' => 1);
		$query = $this->participants_model->fetch('participants','id','',$array);
		$data['total_fake_participants'] = $query->num_rows();

		// Get status
		$data['status'] = ($this->ccsettings->item('draft_mode_q')) ? '<font color="red">'.$this->lang->line('dashboard_programming_draft').'</font>' : '<font color="green">'.$this->lang->line('dashboard_programming_final').'</font>';

		$content = $this->load->view($this->config->item('concentric_template_admin') . 'dashboard/programming_statistics',$data,TRUE);
		//flashMsg('info',$content);
		return $content;
	}

	/**
	* Generate the contents of the help widget and return it as a string.
	*
	* @access private
	* @return string
	*/
	function _widget_help()
	{
		$data = $this->lang->line('dashboard_help_body');
		$data .= '  ';
		$data .= $this->lang->line('dashboard_help_version') . ': ';
		$data .= CC_VERSION;
		return $data;
	}
}


/* End of file home.php */
/* Location: ./system/application/controllers/concentric/home.php */