<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : Departments.php
 *
 * DESCRIPTION   : departments module controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-10-31 11:47 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		departments component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Departments extends Concentric_Controller
{
	/**
	* Contructor function
	*
	* Load the instance of CI by invoking the parent constructor
	*
	* @access      public
	* @return      none
	*/
	function Departments()
	{
		// Call parent constructor
		parent::Concentric_Controller();

		$this->form_name = "Departments";
		$this->load->model('departments_model');    // Instantiate the model
	}

	// -------------------------------------------------------------------------
	/**
	* "Index" Page
	*
	* Default class action
	*
	* @access      public
	* @return      none
	*/
	function index()
	{
		// The default action is the browse action
		$this->browse();
	}

	// -------------------------------------------------------------------------
	// Function: browse()
	// Description: Extracts a list of all data records and
	//              displays it.
	function browse()
	{
		// fetch query object from the model with fields
		$template['departments_list'] = $this->departments_model->fetchDepartments();

		// create urls for use in content view
		$template['base_url']   = 'concentric/departments/browse/';
		$template['edit_url'] = 'concentric/departments/edit/';
		$template['delete_url'] = 'concentric/departments/delete/';
		$template['add_url']    = 'concentric/departments/add/';
		$template['cancel_url'] = 'concentric/home';

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/departments/departments_grid', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);

	}

	// -------------------------------------------------------------------------
	// Function: add()
	// Description: Prompts user for input and adds a new entry
	//              in the database.
	function add()
	{
		$this->_modify('add');
	}

	// -------------------------------------------------------------------------
	// Function: edit()
	// Description: Prompts user for input and updates an entry
	//              in the database.
	function edit()
	{
		$this->_modify('edit');
	}

	// -------------------------------------------------------------------------
	// Function: modify()
	// Description: Prompts user for input and adds/edits an entry
	//              in the database. Default to add mode.
	function _modify($mode = 'add')
	{
		// Initialize variable
		$other_scripts_data = '';

		// load validation library to help validate data
		$this->load->library('validation');

		// create urls and values for use in content view
		$template['form_url'] = 'concentric/departments/' . $mode . '/';
		$template['cancel_url'] = 'concentric/departments/browse';
		$template['form_attributes'] = array( 'method' => 'post', 'id' => $this->form_name, 'name' => $this->form_name );
		$template['header']  = $this->form_name;


		$this->_initialize();   // Setup the fields
		$this->_validation();   // Load the validation rules and fields


		// if validation has not run or if it failed
		if ( $this->validation->run() == FALSE )
		{
			// Save validation errors to flashmsg
			// Will be output in content view by status->display
			$this->validation->output_errors();

			// Get values for form fields and build the form fields
			$status = $this->_get_form_values($mode);

			// If the returned values got an error
			if ($status === FALSE)
			{
				// Show error message
				flashMsg('error','There was a problem editing that record.');
				// redirect to main location
				redirect('/concentric/departments/', 'location');
			}

			// Save field data to array to be passed to content view
			$template['fields'] = $this->fields;

			// build content html using details view and template data
			$data['content'] = $this->load->view('/concentric/details', $template, TRUE);
			// pass other scripts data to container
			$data['other_scripts'] = $other_scripts_data;

			// pass all data to container view and display to user
			$this->load->view($this->_container, $data);
		}
		else  // User is submitting valid data
		{
			// Store the values from the form into the db

			// XXS Filtering enforced for user input
			$data['field']['id']		 = $this->input->post('id', TRUE);
			$data['field']['name']		 = $this->input->post('name', TRUE);
			$data['field']['locationID'] = $this->input->post('locationID', TRUE);

			if ($mode == 'add')
			{
				// add the data to the table and return id
				$idField = $this->departments_model->addRow('departments',$data['field']);
				$status = ($idField) ? TRUE : FALSE;
			}
			else
			{
				$idField = $data['field']['id'];
				// update the data in the table
				$obj = $this->departments_model->update('departments', $data['field'], 'id = ' . $idField);
				$status = ($obj) ? TRUE : FALSE;
			}

			// if there was no error in add or edit
			if ($status)
			{
				// Show success message
				flashMsg('success','Record ' . $idField . ' (' . $data['field']['name'] . ') has been saved.');
			}
			else  // there was an error
			{
				// Show error message
				flashMsg('error','The record for (' . $data['field']['name'] . ') has not been saved.');
			}

			// redirect to main location
			redirect('/concentric/departments/', 'location');
			// ?redirect to add/edit?
			// redirect('/concentric/departments/' . $mode . '/', 'location');
		}
	}

	// -------------------------------------------------------------------------
	// Function: delete()
	// Description: Controller function to process user delete requests
	function delete()
	{
		$idField = $this->uri->segment(4);

		//$confirm = $this->_delete_confirm($idField);  //add later
		$confirm = TRUE;

		if ($confirm)
		{
			if ( $this->departments_model->delete('departments', 'id =' . $idField) )
			{
				flashMsg('success', 'The record has been deleted.');
			}
			else
			{
				flashMsg('error', 'There was a problem deleting the record');
			}
		}

		redirect('/concentric/departments/', 'location');
	}

	// -------------------------------------------------------------------------
	function _delete_confirm($id)
	{
		//add later
	}

	// -------------------------------------------------------------------------
	// id, name, locationID
	function _get_form_values($mode = 'add')
	{
		if ($mode == 'add')
		{
			// Set empty values / default values
			$this->fields['id']['value'] = '';
			$this->fields['name']['value'] = '';
			$this->fields['locationID']['value'] = '';
		}
		else
		{
			//get the id from either the hidden field or the url
			$idField = ($this->input->post('id', TRUE) != '') ? $this->input->post('id', TRUE) : $this->uri->segment(4);

			// fetch query object from the model with all fields
			$qry = $this->departments_model->fetch('departments','id, name, locationID','','id = ' . $idField);

			// There should only be 1 row. If not, return FALSE
			if ($qry->num_rows() != 1)
			{
				return FALSE;
			}

			// Get the single result as an array and save values
			$row = $qry->row_array();
			$this->fields['id']['value'] = $row['id'];
			$this->fields['name']['value'] = $row['name'];
			$this->fields['locationID']['value'] = $row['locationID'];
		}

		// Now build the form fields
		foreach ($this->fields as $field)
		{
			$this->fields[$field['name']]['form'] = build_form_field($field);
		}

		return TRUE;
	}


	// -------------------------------------------------------------------------
	function _validation()
	{

		// load the rules
		$form_rules['name']  = $this->fields['name']['rules'];
		$form_rules['locationID'] = $this->fields['locationID']['rules'];
		$this->validation->set_rules($form_rules);

		// load the field labels
		$form_fields['id']   = $this->fields['id']['label'];
		$form_fields['name'] = $this->fields['name']['label'];
		$form_fields['locationID'] = $this->fields['locationID']['label'];
		$this->validation->set_fields($form_fields);

		// set error delimiters
		$this->validation->set_error_delimiters('<span class="error">', '</span>');

	}


	// -------------------------------------------------------------------------
	/**
	 * Initalize Values
	 * 
	 * @access private
	 * @return void;
	 */
	function _initialize()
	{
		// Setup custom field options - list fields in the order they should
		// appear in the details view
		//   rules - validation rules (optional)
		//   label - descriptive name of the field (optional)
		//   name - database field name ** MUST BE SAME AS KEY ** (required)
		//   desc - long description to show to user on form (optional)
		//   type - set of values (required)
		//            text - basic input box
		//            hidden - keep this field hidden
		//            textarea
		//            checkbox
		//            dropdown
		//            password
		//   class - class name (optional)
		//   script - html script code to insert on the field
		//   after_form_script - html script code to insert after the form has been displayed

		$this->fields['id'] = array('label' => 'Department ID',
							'name' => 'id',
							'type' => 'hidden');
		$this->fields['name'] = array('rules' => 'trim|required|max_length[50]|callback__unique_field[departments.name]|xss_clean',
							'label' => 'Department Name',
							'name' => 'name',
							'desc' => 'Enter the name of the department.',
							'type' => 'text');
		$this->fields['locationID'] = array('rules' => 'trim|required|xss_clean',
										'label' => 'Location',
										'name' => 'locationID',
										'desc' => 'Enter the location for this department',
										'type' => 'dropdown',
										'options' => $this->_get_location_array(),
										'selected' => '');

		return;
	}

	/**
	 * Unique_field
	 * ** Assumes that the db model has already been loaded. **
	 *
	 * @access    private
	 * @param     string  The string to check for in the db.
	 * @param     field   The table and column of the field to check in table.column format
	 * @return    bool
	 */
	function _unique_field($str, $field)
	{
		list($table, $column) = split("\.", $field, 2);

		// Set the error message to use
		$this->validation->set_message('_unique_field','The %s field must have a unique value in the database.');

		$where= isset($_POST['id']) ? array('id !='=> $_POST['id'], $column=>$str) : array($column=>$str);
		$count = $this->departments_model->count_condition($table, $where);
		return ($count > 0) ? FALSE : TRUE;
	}

	/**
	 * Get location array
	 *
	 * @access    private
	 * @return    array
	 */
	 function _get_location_array()
	{
		// Load the location model
		$this->load->model('locations_model');

		// fetch query object from the model with fields id, name
		$query = $this->locations_model->fetch('locations','id, name','','','name ASC');

		// Loop through to build array
		$data = array();
		foreach ($query->result_array() as $row)
		{
			$data[$row['id']] = $row['name'];
		}

		return $data;
	}


	// --------------------------------------------------------------------------------------------
	// Reports
	// --------------------------------------------------------------------------------------------

	// -------------------------------------------------------------------------
	/**
	* Reports Page
	*
	* @access      public
	* @return      none
	*/
	function reports()
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/departments/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumb
		$this->page->set_crumb('Department Reports','concentric/departments/reports/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html
		$data['content'] = $this->load->view('/concentric/departments/departments_reports_menu', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report all data
	*
	* @access      public
	* @return      none
	*/
	function rep_all()
	{
		// fetch query object from the model with fields id, name, locationID
		$template['departments_list'] = $this->departments_model->fetchDepartments();

		// create urls for use in content view
		$template['base_url']   = 'concentric/departments/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Department Reports','concentric/departments/reports/');
		$this->page->set_crumb('List All','concentric/departments/rep_all/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/departments/departments_list_all', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Download all data
	*
	* @access      public
	* @return      none
	*/
	function rep_download_all($eor = '')
	{
		// Load the helper
		$this->load->helper('download');

		// fetch query object from the model with fields id, name
		$query = $this->departments_model->fetch('departments','id, name, locationID','','','id ASC');

		// Initialize values
		$data = '';
		$eor = ($eor == '') ? '' : (',' . $eor);
		// Loop through the data and build the data
		foreach ($query->result_array() as $row)
		{
			$data .= '"' . $row['id'] . '","' . $row['name']. '","' . $row['locationID'] . '"' . $eor . "\n";
		}

		// Download the file
		force_download('departments.csv', $data);

		redirect('/concentric/departments/reports', 'location');
	}


}


/* End of file departments.php */
/* Location: ./system/application/controllers/concentric/departments.php */