<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * MODULE NAME   : departmentHours.php
 *
 * DESCRIPTION   : departmenthours module controller
 *
 * MODIFICATION HISTORY
 *   V1.0   2008-11-19 5:00 PM   - Leane Verhulst     - Created
 *
 * @package			ConCentric
 * @subpackage		departmenthours component Class
 * @author			Leane Verhulst
 * @copyright		Copyright (c) 2008
 * @license			http://www.gnu.org/licenses/gpl.html
 */

class Departmenthours extends Concentric_Controller
{
	/**
	* Contructor function
	*
	* Load the instance of CI by invoking the parent constructor
	*
	* @access      public
	* @return      none
	*/
	function Departmenthours()
	{
		// Call parent constructor
		parent::Concentric_Controller();

		$this->form_name = "DepartmentHours";
		$this->load->model('departmenthours_model');    // Instantiate the model
		// load helper library
		$this->load->helper('concentric');
	}

	// -------------------------------------------------------------------------
	/**
	* "Index" Page
	*
	* Default class action
	*
	* @access      public
	* @return      none
	*/
	function index()
	{
		// The default action is the browse action
		$this->browse();
	}


	// -------------------------------------------------------------------------
	// Function: browse()
	// Description: Extracts a list of all data records and
	//              displays it.
	function browse()
	{
		// fetch query object from the model with fields
		$template['departmenthours_list'] = $this->departmenthours_model->fetchDepartmentHours();

		// create urls for use in content view
		$template['base_url']   = 'concentric/departmentHours/browse/';
		$template['edit_url'] = 'concentric/departmentHours/edit/';
		$template['delete_url'] = 'concentric/departmentHours/delete/';
		$template['add_url']    = 'concentric/departmentHours/add/';
		$template['cancel_url'] = 'concentric/home';

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/departmentHours/departmentHours_grid', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);

	}


	// -------------------------------------------------------------------------
	// Function: add()
	// Description: Prompts user for input and adds a new entry
	//              in the database.
	function add()
	{
		$this->_modify('add');
	}


	// -------------------------------------------------------------------------
	// Function: edit()
	// Description: Prompts user for input and updates an entry
	//              in the database.
	function edit()
	{
		$this->_modify('edit');
	}


	// -------------------------------------------------------------------------
	// Function: modify()
	// Description: Prompts user for input and adds/edits an entry
	//              in the database. Default to add mode.
	function _modify($mode = 'add')
	{
		// Initialize variable
		$other_scripts_data = '';

		// load validation library to help validate data
		$this->load->library('validation');

		// Set breadcrumb
		$this->page->set_crumb('DepartmentHours','concentric/departmentHours/');
		$this->page->set_crumb('Details','concentric/departmentHours/' . $mode);

		// initialize date arrays
		$this->dates_array = datetime_array($this->ccsettings->item('start_date_time'), $this->ccsettings->item('end_date_time'), $this->ccsettings->item('interval_length'));
		$this->dates_array_flip = array_flip($this->dates_array);

		// create urls and values for use in content view
		$template['form_url'] = 'concentric/departmentHours/' . $mode . '/';
		$template['cancel_url'] = 'concentric/departmentHours/browse';
		$template['form_attributes'] = array( 'method' => 'post', 'id' => $this->form_name, 'name' => $this->form_name );
		$template['header']  = $this->form_name;


		$this->_initialize();   // Setup the fields
		$this->_validation();   // Load the validation rules and fields


		// if validation has not run or if it failed
		if ( $this->validation->run() == FALSE )
		{
			// Save validation errors to flashmsg
			// Will be output in content view by status->display
			$this->validation->output_errors();

			// Get values for form fields and build the form fields
			$status = $this->_get_form_values($mode);

			// If the returned values got an error
			if ($status === FALSE)
			{
				// Show error message
				flashMsg('error','There was a problem editing that record.');
				// redirect to main location
				redirect('/concentric/departmentHours/', 'location');
			}

			// Save field data to array to be passed to content view
			$template['fields'] = $this->fields;

			// build content html using details view and template data
			$data['content'] = $this->load->view('/concentric/details', $template, TRUE);
			// pass other scripts data to container
			$data['other_scripts'] = $other_scripts_data;

			// pass all data to container view and display to user
			$this->load->view($this->_container, $data);
		}
		else  // User is submitting valid data
		{
			// Store the values from the form into the db

			// XXS Filtering enforced for user input
			$data['field']['id']		 = $this->input->post('id', TRUE);
			$data['field']['departmentID'] = $this->input->post('departmentID', TRUE);
			$data['field']['datetime']		 = $this->input->post('datetime', TRUE);
			$data['field']['datetime']		= $this->dates_array[$data['field']['datetime']];
			$data['field']['type']		 = $this->input->post('type', TRUE);

			if ($mode == 'add')
			{
				// add the data to the table and return id
				$idField = $this->departmenthours_model->addRow('departmenthours',$data['field']);
				$status = ($idField) ? TRUE : FALSE;
			}
			else
			{
				$idField = $data['field']['id'];
				// update the data in the table
				$obj = $this->departmenthours_model->update('departmenthours', $data['field'], 'id = ' . $idField);
				$status = ($obj) ? TRUE : FALSE;
			}

			// if there was no error in add or edit
			if ($status)
			{
				// Show success message
				flashMsg('success','Record ' . $idField . ' has been saved.');
			}
			else  // there was an error
			{
				// Show error message
				flashMsg('error','The record has not been saved.');
			}

			// redirect to main location
			redirect('/concentric/departmentHours/', 'location');
			// ?redirect to add/edit?
			// redirect('/concentric/departmentHours/' . $mode . '/', 'location');
		}
	}


	// -------------------------------------------------------------------------
	// Function: delete()
	// Description: Controller function to process user delete requests
	function delete()
	{
		$idField = $this->uri->segment(4);

		//$confirm = $this->_delete_confirm($idField);  //add later
		$confirm = TRUE;

		if ($confirm)
		{
			if ( $this->departmenthours_model->delete('departmenthours', 'id =' . $idField) )
			{
				flashMsg('success', 'The record has been deleted.');
			}
			else
			{
				flashMsg('error', 'There was a problem deleting the record');
			}
		}

		redirect('/concentric/departmentHours/', 'location');
	}


	// -------------------------------------------------------------------------
	function _delete_confirm($id)
	{
		//add later
	}


	// -------------------------------------------------------------------------
	// id, name, locationID
	function _get_form_values($mode = 'add')
	{
		if ($mode == 'add')
		{
			// Set empty values / default values
			$this->fields['id']['value'] = '';
			$this->fields['departmentID']['value'] = '';
			$this->fields['datetime']['value'] = 0;
			$this->fields['type']['value'] = '';
		}
		else
		{
			//get the id from either the hidden field or the url
			$idField = ($this->input->post('id', TRUE) != '') ? $this->input->post('id', TRUE) : $this->uri->segment(4);

			// fetch query object from the model with all fields
			$qry = $this->departmenthours_model->fetch('departmenthours','id, departmentID, datetime, type','','id = ' . $idField);

			// There should only be 1 row. If not, return FALSE
			if ($qry->num_rows() != 1)
			{
				return FALSE;
			}

			// Get the single result as an array and save values
			$row = $qry->row_array();
			$this->fields['id']['value'] = $row['id'];
			$this->fields['departmentID']['value'] = $row['departmentID'];
			$this->fields['datetime']['value'] = ($row['datetime'] == '0000-00-00 00:00:00') ? '' : $row['datetime'];
			$this->fields['datetime']['selected'] = ($this->fields['datetime']['value'] == '') ? '' : $this->dates_array_flip[$this->fields['datetime']['value']];
			$this->fields['type']['value'] = $row['type'];
		}

		// Now build the form fields
		foreach ($this->fields as $field)
		{
			$this->fields[$field['name']]['form'] = build_form_field($field);
		}

		return TRUE;
	}


	// -------------------------------------------------------------------------
	function _validation()
	{

		// load the rules
		$form_rules['departmentID'] = $this->fields['departmentID']['rules'];
		$form_rules['datetime']  = $this->fields['datetime']['rules'];
		$form_rules['type']  = $this->fields['type']['rules'];
		$this->validation->set_rules($form_rules);

		// load the field labels
		$form_fields['id']   = $this->fields['id']['label'];
		$form_fields['departmentID'] = $this->fields['departmentID']['label'];
		$form_fields['datetime'] = $this->fields['datetime']['label'];
		$form_fields['type'] = $this->fields['type']['label'];
		$this->validation->set_fields($form_fields);

		// set error delimiters
		$this->validation->set_error_delimiters('<span class="error">', '</span>');

	}


	// -------------------------------------------------------------------------
	/**
	 * Initalize Values
	 * 
	 * @access private
	 * @return void;
	 */
	function _initialize()
	{
		// Setup custom field options - list fields in the order they should
		// appear in the details view
		//   rules - validation rules (optional)
		//   label - descriptive name of the field (optional)
		//   name - database field name ** MUST BE SAME AS KEY ** (required)
		//   desc - long description to show to user on form (optional)
		//   type - set of values (required)
		//            text - basic input box
		//            hidden - keep this field hidden
		//            textarea
		//            checkbox
		//            dropdown
		//            password
		//   class - class name (optional)
		//   script - html script code to insert on the field
		//   after_form_script - html script code to insert after the form has been displayed

		$this->fields['id'] = array('label' => 'DepartmentHour ID',
							'name' => 'id',
							'type' => 'hidden');
		$this->fields['departmentID'] = array('rules' => 'trim|required|xss_clean',
										'label' => 'DepartmentID',
										'name' => 'departmentID',
										'desc' => 'Enter the department.',
										'type' => 'dropdown',
										'options' => $this->_get_department_array(),
										'selected' => '');
		$this->fields['datetime'] = array('rules' => 'trim|required|xss_clean',
							'label' => 'Date/Time',
							'name' => 'datetime',
							'desc' => 'Enter a date and time for this item in yyyy-mm-dd hh:mi:ss format. Valid dates are from ' . $this->ccsettings->item('start_date_time') . ' thru ' . $this->ccsettings->item('end_date_time'),
							'type' => 'dropdown',
							'options' => $this->dates_array,
							'selected' => '');
		$this->fields['type'] = array('rules' => 'trim|max_length[50]|alpha_dash_space|xss_clean',
							'label' => 'Type',
							'name' => 'type',
							'desc' => 'Enter the type for this datetime.',
							'type' => 'text');

		return;
	}


	/**
	 * Get department array
	 *
	 * @access    private
	 * @return    array
	 */
	 function _get_department_array()
	{
		// Load the department model
		$this->load->model('departments_model');

		// fetch query object from the model with fields id, name
		$query = $this->departments_model->fetch('departments','id, name','','','name ASC');

		// Loop through to build array
		$data = array();
		foreach ($query->result_array() as $row)
		{
			$data[$row['id']] = $row['name'];
		}

		return $data;
	}




	// --------------------------------------------------------------------------------------------
	// Reports
	// --------------------------------------------------------------------------------------------

	// -------------------------------------------------------------------------
	/**
	* Reports Page
	*
	* @access      public
	* @return      none
	*/
	function reports()
	{
		// create urls for use in content view
		$template['base_url']   = 'concentric/departmentHours/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumb
		$this->page->set_crumb('Department Hours Reports','concentric/departmentHours/reports/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html
		$data['content'] = $this->load->view('/concentric/departmentHours/departmentHours_reports_menu', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Report all data
	*
	* @access      public
	* @return      none
	*/
	function rep_all()
	{
		// fetch query object from the model with fields
		$template['departmenthours_list'] = $this->departmenthours_model->fetchDepartmentHours();

		// create urls for use in content view
		$template['base_url']   = 'concentric/departmentHours/reports/';
		$template['cancel_url'] = 'concentric/home';

		// Set breadcrumbs
		$this->page->set_crumb('Department Hour Reports','concentric/departmentHours/reports/');
		$this->page->set_crumb('List All','concentric/departmentHours/rep_all/');

		// set values for use in content view
		$template['form_attributes'] = array('name' => $this->form_name, 'id' => $this->form_name);
		$template['header'] = $this->form_name;

		// build content html using grid view and template data
		$data['content'] = $this->load->view('/concentric/departmentHours/departmentHours_list_all', $template, TRUE);

		// set values for use in header view
		$data['header']  = $this->form_name;

		// pass all data to container view and display to user
		$this->load->view($this->_container,$data);
	}

	// -------------------------------------------------------------------------
	/**
	* Download all data
	*
	* @access      public
	* @return      none
	*/
	function rep_download_all($eor = '')
	{
		// Load the helper
		$this->load->helper('download');

		// fetch query object from the model with fields
		$query = $this->departmenthours_model->fetch('departmenthours','id, departmentID, datetime, type','','','id ASC');

		// Initialize values
		$data = '';
		$eor = ($eor == '') ? '' : (',' . $eor);
		// Loop through the data and build the data
		foreach ($query->result_array() as $row)
		{
			$data .= '"' . $row['id'] . '","' . $row['departmentID'] . '","' . $row['datetime'] . '","' . $row['type'] . '"' . $eor . "\n";
		}

		// Download the file
		force_download('departmenthours.csv', $data);

		redirect('/concentric/departmentHours/reports', 'location');
	}




}


/* End of file departmentHours.php */
/* Location: ./system/application/controllers/concentric/departmentHours.php */