<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
* ConCentric
*
* A website for Centralized Convention administration
*
* @package			ConCentric
* @author			Leane Verhulst
* @copyright		Copyright (c) 2008
* @license			http://www.gnu.org/licenses/gpl.html
*/

// ---------------------------------------------------------------------------

/**
* Ccsettings_model
*
* Model used to retrieve website options
*
* @package			ConCentric
* @subpackage		Models
*/
class Ccsettings_model extends Base_model
{
	function Ccsettings_model()
	{
		// Call parent constructor
		parent::Base_model();

		$this->_TABLES = array('Setting' => $this->config->item('concentric_table_prefix') . 'settings');

		// Cache to store already fetched items
		$this->_CACHE = array();

		log_message('debug','Ccsettings_model Class Initialized');
	}

	/**
	* Get Option
	*
	* Get a option with name $name from the database
	*
	* @access public
	* @param string $name Option name
	* @return string
	*/
	function item($name = NULL)
	{
		if( is_null($name))
			return;

		// See if we have already got the setting
		if( isset($this->_CACHE[$name]))
			return $this->_CACHE[$name];

		// Fetch setting from database
		$query = $this->fetch('Setting','value',null,array('name'=>$name));

		if($query->num_rows() != 0)
		{
			$row = $query->row();
			$string = $row->value;

			log_message('debug',"Fetching the setting '".$name."'");
			$this->_CACHE[$name] = $string;
			return $string;
		}
		else
		{
			show_error("The setting '".$name."' is not valid.");
			return FALSE;
		}
	}

	/**
	* Set Option
	*
	* Updates an option value in the database
	*
	* @access public
	* @param string $name Option name
	* @param string $value Option value
	* @return boolean
	*/
	function set_item($name = NULL, $value = NULL)
	{
		if( is_null($name))
			return FALSE;

		return $this->update('Setting',array('value'=>$value),array('name'=>$name));
	}
}


/* End of file ccsettings_model.php */
/* Location: ../modules/ccsettings/models/ccsettings_model.php */